<?php
/*
* Wise Script Widget
*
*/
use Carbon_Fields\Widget;
use Carbon_Fields\Field;

class WiseScriptWidget extends Widget {

	// Register widget function. Must have the same name as the class
	function __construct() {
		$this->setup( 'wise_script_widget', esc_attr__( '#Wise Script', 'wise-mag' ), esc_attr__( 'Add script from sidebar.', 'wise-mag' ) , array(
			Field::make( 'text', 'wise_script_title', esc_attr__( 'Title:', 'wise-mag' ) ),
			Field::make( 'checkbox', 'wise_script_title_dis', esc_attr__( 'Disable Title', 'wise-mag' ) )
				->set_default_value('yes'),
			Field::make( 'textarea', 'wise_script_content', esc_attr__( 'Enter your custom script here:', 'wise-mag' ) )
		));
		$this->print_wrappers = false; // disable wrapper
	}

	// Called when rendering the widget in the front-end
	function front_end($args, $instance) {
		$before_widget = !empty( $args['before_widget'] ) ? $args['before_widget'] : '';
		$before_title = !empty( $args['before_title'] ) ? $args['before_title'] : '';
		$after_title = !empty( $args['after_title'] ) ? $args['after_title'] : '';
		$after_widget = !empty( $args['after_widget'] ) ? $args['after_widget'] : '';
		
		$wise_title = !empty( $instance['wise_script_title'] ) ? $instance['wise_script_title'] : '';
		$wise_title_dis = !empty( $instance['wise_script_title_dis'] ) ? $instance['wise_script_title_dis'] : '';
		$wise_script_content = !empty( $instance['wise_script_content'] ) ? $instance['wise_script_content'] : '';
		
		echo wp_kses_post($before_widget); // Before widget
		
		if( $wise_title_dis != 'yes' ) :
			if ( !empty($wise_title) ) { // Widget title
				echo wp_kses_post($before_title) . esc_html($wise_title) . wp_kses_post($after_title);
			} else {
				echo wp_kses_post($before_title) . esc_html__( 'Script', 'wise-mag' ) . wp_kses_post($after_title);
			}
		endif;

		echo !empty($wise_script_content) ? $wise_script_content : null;
		
		echo wp_kses_post($after_widget); // After widget
		
	} // End args, instance
}