<?php
/*
* Wise About Widget
*
*/
use Carbon_Fields\Widget;
use Carbon_Fields\Field;

class AboutWidget extends Widget {
		
	// Register widget function. Must have the same name as the class
	function __construct() {
		$this->setup( 'wise_about_widget', esc_attr__( '#Wise About', 'wise-mag' ), esc_attr__( 'Displays about widget.', 'wise-mag' ) , array(
			Field::make( 'text', 'wise_about_title', esc_attr__( 'Title:', 'wise-mag' ) ),
			Field::make( 'checkbox', 'wise_about_title_dis', esc_attr__( 'Disable Title', 'wise-mag' ) )
				->set_default_value('yes'),
			Field::make( 'image', 'wise_about_img', esc_attr__( 'About Image Logo', 'wise-mag' ) )
				->set_value_type( 'url' ),
			Field::make( 'checkbox', 'wise_about_img_dis', esc_attr__( 'Disable Logo Image', 'wise-mag' ) )
				->set_default_value('no'),
			Field::make( 'textarea', 'wise_about_content', esc_attr__( 'Content:', 'wise-mag' ) ),
			Field::make( 'checkbox', 'wise_about_content_dis', esc_attr__( 'Disable Content', 'wise-mag' ) )
				->set_default_value('no'),			
			Field::make( 'text', 'wise_about_location', esc_attr__( 'Location:', 'wise-mag' ) ),
			Field::make( 'checkbox', 'wise_about_location_dis', esc_attr__( 'Disable Location', 'wise-mag' ) )
				->set_default_value('no'),
			Field::make( 'text', 'wise_about_email', esc_attr__( 'Email:', 'wise-mag' ) ),
			Field::make( 'checkbox', 'wise_about_email_dis', esc_attr__( 'Disable Email', 'wise-mag' ) )
				->set_default_value('no'),
			Field::make( 'text', 'wise_about_phone', esc_attr__( 'Phone:', 'wise-mag' ) ),
			Field::make( 'checkbox', 'wise_about_phone_dis', esc_attr__( 'Disable Phone', 'wise-mag' ) )
				->set_default_value('no'),
			Field::make( 'checkbox', 'wise_enable_social', esc_attr__( 'Enable Social Buttons', 'wise-mag' ) )
				->set_default_value('yes')
		));
		$this->print_wrappers = false; // disable wrapper
	}

	// Called when rendering the widget in the front-end
	function front_end($args, $instance) {
		$before_widget = !empty( $args['before_widget'] ) ? $args['before_widget'] : '';
		$before_title = !empty( $args['before_title'] ) ? $args['before_title'] : '';
		$after_title = !empty( $args['after_title'] ) ? $args['after_title'] : '';
		$after_widget = !empty( $args['after_widget'] ) ? $args['after_widget'] : '';
		
		$wise_title = !empty( $instance['wise_about_title'] ) ? $instance['wise_about_title'] : '';
		$wise_title_dis = !empty( $instance['wise_about_title_dis'] ) ? $instance['wise_about_title_dis'] : '';
		$about_img = !empty( $instance['wise_about_img'] ) ? $instance['wise_about_img'] : '';
		$about_img_dis = !empty( $instance['wise_about_img_dis'] ) ? $instance['wise_about_img_dis'] : '';
		$about_content = !empty( $instance['wise_about_content'] ) ? $instance['wise_about_content'] : '';
		$wise_about_content_dis = !empty( $instance['wise_about_content_dis'] ) ? $instance['wise_about_content_dis'] : '';
		
		$wise_about_location = !empty( $instance['wise_about_location'] ) ? $instance['wise_about_location'] : '';
		$wise_about_location_dis = !empty( $instance['wise_about_location_dis'] ) ? $instance['wise_about_location_dis'] : '';
		$wise_about_email = !empty( $instance['wise_about_email'] ) ? $instance['wise_about_email'] : '';
		$wise_about_email_dis = !empty( $instance['wise_about_email_dis'] ) ? $instance['wise_about_email_dis'] : '';
		$wise_about_phone = !empty( $instance['wise_about_phone'] ) ? $instance['wise_about_phone'] : '';
		$wise_about_phone_dis = !empty( $instance['wise_about_phone_dis'] ) ? $instance['wise_about_phone_dis'] : '';
		
		$about_url = !empty( $instance['wise_about_url'] ) ? $instance['wise_about_url'] : '';
		$enable_social = !empty( $instance['wise_enable_social'] ) ? $instance['wise_enable_social'] : '';

		echo wp_kses_post($before_widget); // Before widget
		
		if( $wise_title_dis != 'yes' ) :
			if ( !empty($wise_title) ) { // Widget title
				echo wp_kses_post($before_title) . esc_html($wise_title) . wp_kses_post($after_title);
			} else {
				echo wp_kses_post($before_title) . esc_html__( 'About Us', 'wise-mag' ) . wp_kses_post($after_title);
			}
		endif;

		// The Output
		if( $about_img_dis != 'yes' ) :
			$def_footer_url = get_template_directory_uri() . '/img/footer_logo.png';			
			if( !empty($about_img) ) {
				if( !empty($about_url) ) {
					echo '<div class="about-logo"><a href="' . esc_url($about_url) . '">';
				} else {
					echo '<div class="about-logo"><a href="' . esc_url( home_url('/') ) . '">';
				}
				echo '<img src="' . esc_url($about_img) . '" alt="' . esc_attr( get_the_title() ) . '"></a></div>';
			} else {
				if( !empty($about_url) ) {
					echo '<div class="about-logo"><a href="' . esc_url($about_url) . '">';
				} else {
					echo '<div class="about-logo"><a href="' . esc_url( home_url('/') ) . '">';
				}
				echo '<img src="' . esc_url($def_footer_url) . '" alt="' . esc_attr( get_the_title() ) . '"></a></div>';
			}
		endif;

		if( $wise_about_content_dis != 'yes' ) :
			if( !empty($about_content) ) {
				echo '<div class="about-text"><p>' . esc_html($about_content);			
			} else {
				echo '<div class="about-text"><p>' . esc_html__( 'Wise Mag is the wisest AD optimized magazine blog WordPress theme for all people, especially for bloggers and online entrepreneurs.', 'wise-mag' );
			}
		endif;

		if( $wise_about_location_dis != 'yes' ) :
			if( !empty($wise_about_location) ) {
				echo '<p><strong>' . esc_html__('Location: ', 'wise-mag') . '</strong>' . esc_html($wise_about_location);
			} else {
				echo '<p><strong>' . esc_html__('Location: ', 'wise-mag') . '</strong>' . esc_html__( 'Atlanta, GA 30338', 'wise-mag' );
			}
		endif;
		
		if( $wise_about_email_dis != 'yes' ) :
			if( !empty($wise_about_email) ) {
				echo '<br><strong>' . esc_html__('Email: ', 'wise-mag') . '</strong><a href="mailto:' . esc_html($wise_about_email) . '">' . esc_html($wise_about_email) . '</a>';
			} else {
				echo '<br><strong>' . esc_html__('Email: ', 'wise-mag') . '</strong><a href="mailto:' . esc_html__( 'steve.probewise@gmail.com', 'wise-mag' ) . '">' . esc_html__( 'steve.probewise@gmail.com', 'wise-mag' ) . '</a>';
			}
		endif;
		
		if( $wise_about_phone_dis != 'yes' ) :
			if( !empty($wise_about_phone) ) {
				echo '<br><strong>' . esc_html__('Phone: ', 'wise-mag') . '</strong>' . esc_html($wise_about_phone);
			} else {
				echo '<br><strong>' . esc_html__('Phone: ', 'wise-mag') . '</strong>' . esc_html__( '+63-123-123-1234', 'wise-mag' );
			}
		endif;
		
		echo '</p></div>';

		if( $enable_social == 'yes' ) {	
			if( function_exists('wise_footer_social_menu') ) : wise_footer_social_menu(); endif; // Social Media Footer
		} else { // If enable social is unchecked
			if( !empty($about_url) ) {
				echo '<span class="nolinehover"><a href="' . esc_url($about_url) . '">' . esc_html__( 'Read More', 'wise-mag' ) . '</a></span>';
			} else {
				echo '<span class="nolinehover"><a href="' . esc_url( home_url('/') ) . '">' . esc_html__( 'Read More', 'wise-mag' ) . '</a></span>';
			}			
		}
		
		echo wp_kses_post($after_widget); // After widget
		
	} // End args, instance

} // End class