<?php
/*
* Wise Text Alert Widget
*
*/
use Carbon_Fields\Widget;
use Carbon_Fields\Field;

class WiseTextAlertWidget extends Widget {

	// Register widget function. Must have the same name as the class
	function __construct() {
		$this->setup( 'wise_text_alert_widget', esc_attr__( '#Wise Text Alert', 'wise-mag' ), esc_attr__( 'Displays text alert widget', 'wise-mag' ) , array(
			Field::make( 'textarea', 'wise_text_alert', esc_attr__( 'Contents:', 'wise-mag' ) )
		));
		$this->print_wrappers = false; // disable wrapper
	}

	// Called when rendering the widget in the front-end
	function front_end($args, $instance) {
		$before_widget = !empty( $args['before_widget'] ) ? $args['before_widget'] : '';
		$after_widget = !empty( $args['after_widget'] ) ? $args['after_widget'] : '';

		$wise_text_alert = !empty( $instance['wise_text_alert'] ) ? $instance['wise_text_alert'] : '';

		echo wp_kses_post($before_widget); // Before widget

		echo '<div class="widget_text_alert">' . wp_kses_post($wise_text_alert) . '</div>';

		echo wp_kses_post($after_widget); // After widget

	} // End args, instance

} // End class