<?php
/*
* Wise Dashboard User Widget
*
*/
use Carbon_Fields\Widget;
use Carbon_Fields\Field;

class DashboardUserWidget extends Widget {
	
	// Register widget function. Must have the same name as the class
	function __construct() {
		$this->setup( 'wise_dash_widget', esc_attr__( '#Wise Dashboard User', 'wise-mag' ), esc_attr__( 'Displays dashboard user widget.', 'wise-mag' ) , array(
			Field::make( 'textarea', 'wise_dash_notice_login', esc_attr__( 'Dashboard user notice when logged in:', 'wise-mag' ) ),
			Field::make( 'textarea', 'wise_dash_notice_logout', esc_attr__( 'Dashboard user notice when logged out:', 'wise-mag' ) )
		));
		$this->print_wrappers = false; // disable wrapper
	}

	// Called when rendering the widget in the front-end
	function front_end($args, $instance) {
		$before_widget = !empty( $args['before_widget'] ) ? $args['before_widget'] : '';
		$after_widget = !empty( $args['after_widget'] ) ? $args['after_widget'] : '';
		
		$wise_dash_notice_login = !empty( $instance['wise_dash_notice_login'] ) ? $instance['wise_dash_notice_login'] : '';
		$wise_dash_notice_logout = !empty( $instance['wise_dash_notice_logout'] ) ? $instance['wise_dash_notice_logout'] : '';
		
		echo wp_kses_post($before_widget); // Before widget
		
		?>
		<div class="dash-all">
			<?php echo esc_html__('Welcome', 'wise-mag') . '&#44; '; ?>
			<div class="dash-gravatar"><?php $current_user = wp_get_current_user(); wp_get_current_user(); echo wp_kses_post(get_avatar( $current_user->ID, 50 ));  ?></div>
			<h2 class="dash-name"><?php if(is_user_logged_in()) { echo esc_attr(wp_get_current_user()->display_name); } else { echo esc_html__('Guest','wise-mag'); } ?></h2>		
			<?php if (is_user_logged_in()) { ?>
				<div class="dash-tools">
					<a href="<?php echo esc_url( home_url('/') . 'wp-admin/'); ?>"><?php esc_html_e( 'Dashboard', 'wise-mag' ); ?></a>
					<?php if(function_exists('is_woocommerce') && is_woocommerce() ) : echo '<a class="dash-home" href="' . esc_url(wc_customer_edit_account_url()) . '">' . esc_html__( 'Edit Account', 'wise-mag') . '</a>';
						else : echo '<a class="dash-home" href="' . esc_url( home_url('/') . 'wp-admin/profile.php') . '">' . esc_html__( 'Edit Account', 'wise-mag') . '</a>'; endif; ?>
				</div>
				<a class="dash-out" href="<?php echo esc_url( wp_logout_url(home_url('/')) ); ?>"><?php esc_html_e( 'Log out', 'wise-mag' ); ?></a>
				<span class="dash-notice"><i>
					<?php
					if( !empty($wise_dash_notice_login) ) {
						echo wp_kses_post($wise_dash_notice_login);
					} else {
						echo wp_kses_post( __( 'You are logged in.', 'wise-mag' ) );
					} ?></i></span>
			<?php } else { ?>
				<div class="dash-tools">
					<a class="lg-in" href="<?php echo esc_url( home_url('/') . 'wp-admin/'); ?>"><?php esc_html_e( 'Login', 'wise-mag' ); ?></a>
					<a class="lg-reg dash-home" href="<?php echo esc_url( home_url('/') . 'wp-login.php?action=register'); ?>"><?php echo esc_html__( 'Register', 'wise-mag' ); ?></a>
				</div>
				<span class="dash-notice"><i>
					<?php
					if( !empty($wise_dash_notice_logout) ) {
						echo wp_kses_post($wise_dash_notice_logout);
					} else {
						echo wp_kses_post( __( 'You are logged out.', 'wise-mag' ) );
					} ?></i></span>
			<?php } ?>
		</div>
		<?php
		
		echo wp_kses_post($after_widget); // After widget
	
	} // End args, instance

} // End class