<?php
/*
* Wise Subscribe Footer Widget
*
*/
use Carbon_Fields\Widget;
use Carbon_Fields\Field;

class SubscribeFooterWidget extends Widget {
	
	// Register widget function. Must have the same name as the class
	function __construct() {
		$this->setup( 'wise_subsfoot_widget', esc_attr__( '#Wise Subscribe Footer', 'wise-mag' ), esc_attr__( 'Displays subscribe footer widget.', 'wise-mag' ) , array(
			Field::make( 'text', 'wise_subs_title', esc_attr__( 'Title:', 'wise-mag' ) ),
			Field::make( 'checkbox', 'wise_subs_title_dis', esc_attr__( 'Disable Title', 'wise-mag' ) )
				->set_default_value('no'),
			Field::make( 'text', 'wise_subs_url', esc_attr__( 'Subscribe URL:', 'wise-mag' ) ),
		));
		$this->print_wrappers = false; // disable wrapper
	}

	// Called when rendering the widget in the front-end
	function front_end($args, $instance) {
		$before_widget = !empty( $args['before_widget'] ) ? $args['before_widget'] : '';
		$before_title = !empty( $args['before_title'] ) ? $args['before_title'] : '';
		$after_title = !empty( $args['after_title'] ) ? $args['after_title'] : '';
		$after_widget = !empty( $args['after_widget'] ) ? $args['after_widget'] : '';

		$wise_title = !empty( $instance['wise_subs_title'] ) ? $instance['wise_subs_title'] : '';
		$wise_title_dis = !empty( $instance['wise_subs_title_dis'] ) ? $instance['wise_subs_title_dis'] : '';
		$wise_subs_url = !empty( $instance['wise_subs_url'] ) ? $instance['wise_subs_url'] : '';

		echo wp_kses_post($before_widget); // Before widget

		if( $wise_title_dis != 'yes' ) :
			if ( !empty($wise_title) ) { // Widget title
				echo wp_kses_post($before_title) . esc_html($wise_title) . wp_kses_post($after_title);
			} else {
				echo wp_kses_post($before_title) . esc_html__( 'Subscribe to our Newsletter', 'wise-mag' ) . wp_kses_post($after_title);
			}
		endif;

		// The Output
		echo '<form class="subscribe-footer" action="' . esc_url($wise_subs_url) . '" method="post" id="mc-embedded-subscribe-form-footer" name="mc-embedded-subscribe-form" target="_blank" novalidate>';
		echo '<input type="email" value="" name="EMAIL"  id="mce-EMAIL-footer" placeholder="' . esc_attr__('Enter Email Address', 'wise-mag') . '">';
		echo '<button type="submit" class="newsletter-submit" value="' . esc_attr__('Subscribe','wise-mag') . '" name="subscribe" id="mc-embedded-subscribe-footer">' . esc_html__('Subscribe','wise-mag') . '</button></form>';
				
		echo wp_kses_post($after_widget); // After widget

	} // End args, instance

} // End class