<?php
/*
* Wise Social Media Footer Widget
*
*/
use Carbon_Fields\Widget;
use Carbon_Fields\Field;

class SocialMediaFooterWidget extends Widget {

	// Register widget function. Must have the same name as the class
	function __construct() {
		$this->setup( 'wise_socfooter_widget', esc_attr__( '#Wise Social Media Footer', 'wise-mag' ), esc_attr__( 'Displays social media footer widget.', 'wise-mag' ) , array(
			Field::make( 'separator', 'wise_pop_style_options', esc_attr__( 'This is a widget to display social media for footer.', 'wise-mag' ) )
		));
		$this->print_wrappers = false; // disable wrapper
	}

	// Called when rendering the widget in the front-end
	function front_end($args, $instance) {
		$before_widget = !empty( $args['before_widget'] ) ? $args['before_widget'] : '';
		$after_widget = !empty( $args['after_widget'] ) ? $args['after_widget'] : '';

		echo wp_kses_post($before_widget); // Before widget	

		if( function_exists('wise_footer_social_menu') ) : wise_footer_social_menu(); endif;

		echo wp_kses_post($after_widget); // After widget
	} // End args, instance

} // End class