<?php
/*
* Wise Subscribe Sidebar Widget
*
*/
use Carbon_Fields\Widget;
use Carbon_Fields\Field;

class SubscribeSidebarWidget extends Widget {
	
    // Register widget function. Must have the same name as the class
    function __construct() {
        $this->setup( 'wise_subside_widget', esc_attr__( '#Wise Subscribe Sidebar', 'wise-church' ), esc_attr__( 'Displays subscribe sidebar widget.', 'wise-church' ) , array(
			Field::make( 'text', 'wise_subside_title', esc_attr__( 'Title:', 'wise-church' ) ),
			Field::make( 'checkbox', 'wise_subside_title_dis', esc_attr__( 'Disable Title', 'wise-church' ) )
				->set_default_value('no'),
			Field::make( 'textarea', 'wise_subside_head', esc_attr__( 'Subscribe Heading:', 'wise-church' ) ),
			Field::make( 'text', 'wise_subside_url', esc_attr__( 'Subscribe URL:', 'wise-church' ) )
        ));
		$this->print_wrappers = false; // disable wrapper
    }

    // Called when rendering the widget in the front-end
    function front_end($args, $instance) {
		$before_widget = !empty( $args['before_widget'] ) ? $args['before_widget'] : '';
		$before_title = !empty( $args['before_title'] ) ? $args['before_title'] : '';
		$after_title = !empty( $args['after_title'] ) ? $args['after_title'] : '';
		$after_widget = !empty( $args['after_widget'] ) ? $args['after_widget'] : '';
		
		$wise_title = !empty( $instance['wise_subside_title'] ) ? $instance['wise_subside_title'] : '';
		$wise_title_dis = !empty( $instance['wise_subside_title_dis'] ) ? $instance['wise_subside_title_dis'] : '';
		$wise_subside_head = !empty( $instance['wise_subside_head'] ) ? $instance['wise_subside_head'] : '';
		$wise_subside_url = !empty( $instance['wise_subside_url'] ) ? $instance['wise_subside_url'] : '';		
		
		echo wp_kses_post($before_widget); // Before widget
		
		if ( !empty($wise_title) ) { // Widget title
			echo wp_kses_post($before_title) . esc_html($wise_title) . wp_kses_post($after_title);
		} else {
			echo wp_kses_post($before_title) . esc_html__( 'Subscribe to Probewise', 'wise-church' ) . wp_kses_post($after_title);
		}
		
		// The Output
		if( !empty($wise_subside_head) ) {
			echo '<div class="subscribe-box"><span>' . esc_html($wise_subside_head) . '</span>';
		} else {
			echo '<div class="subscribe-box"><span>' . esc_html__( 'Get updated from the latest posts straight to your mailbox!', 'wise-church' ) . '</span>';
		}
		echo '<form class="subscribe-sidebar" action="' . esc_url($wise_subside_url) . '" method="post" id="mc-embedded-subscribe-form" name="mc-embedded-subscribe-form" target="_blank" novalidate>';
		echo '<input type="email" value="" name="EMAIL"  id="mce-EMAIL" placeholder="' . esc_attr__('Enter Email Address', 'wise-church') . '">';
		echo '<button type="submit" class="newsletter-submit" value="' . esc_attr__('Subscribe','wise-church') . '" name="subscribe" id="mc-embedded-subscribe">' . esc_html__('Subscribe','wise-church') . '</button></form></div>';
		
		echo wp_kses_post($after_widget); // After widget
		
    } // End args, instance
}