<?php
/*
* Wise Popular Posts Widget
*
*/
use Carbon_Fields\Widget;
use Carbon_Fields\Field;

class PopularPostsWidget extends Widget {
	
    // Register widget function. Must have the same name as the class
    function __construct() {
		global $wp_cats;
        $this->setup( 'wise_pop_widget', esc_attr__( '#Wise Popular Posts', 'wise-church' ), esc_attr__( 'Displays popular posts widget.', 'wise-church' ) , array(
			Field::make( 'text', 'wise_pop_title', esc_attr__( 'Title:', 'wise-church' ) ),
			Field::make( 'text', 'wise_pop_number', esc_attr__( 'Number of posts to show:', 'wise-church' ) )->set_default_value('4'),
			Field::make( 'select', 'wise_pop_categ', esc_attr__( 'Select Category:', 'wise-church' ) )
				->add_options($wp_cats),
			Field::make( 'radio', 'wise_pop_popularby', esc_attr__( 'Popular posts created on:', 'wise-church' ) )
				->add_options(array(
					'weekly' => esc_attr__( 'This Week', 'wise-church' ),
					'monthly' => esc_attr__( 'This Month', 'wise-church' ),
					'yearly' => esc_attr__( 'This Year', 'wise-church' ),
					'alltime' => esc_attr__( 'All Time', 'wise-church' ),
				))->set_default_value('alltime')
        ));
		$this->print_wrappers = false; // disable wrapper
    }

    // Called when rendering the widget in the front-end
    function front_end($args, $instance) {
		global $wise_allowed_html;
		$before_widget = !empty( $args['before_widget'] ) ? $args['before_widget'] : '';
		$before_title = !empty( $args['before_title'] ) ? $args['before_title'] : '';
		$after_title = !empty( $args['after_title'] ) ? $args['after_title'] : '';
		$after_widget = !empty( $args['after_widget'] ) ? $args['after_widget'] : '';
		
		$wise_title = !empty( $instance['wise_pop_title'] ) ? $instance['wise_pop_title'] : '';
		$number = !empty( $instance['wise_pop_number'] ) ? $instance['wise_pop_number'] : '';
		$categ = !empty( $instance['wise_pop_categ'] ) ? $instance['wise_pop_categ'] : '';
		$popularby = !empty( $instance['wise_pop_popularby'] ) ? $instance['wise_pop_popularby'] : '';
		
		echo wp_kses_post($before_widget); // Before widget
		
		if ( !empty($wise_title) ) { // Widget title
			echo wp_kses_post($before_title) . esc_html($wise_title) . wp_kses_post($after_title);
		} else {
			echo wp_kses_post($before_title) . esc_html__( 'Popular Posts', 'wise-church' ) . wp_kses_post($after_title);
		}
		
		// The Output
		echo '<div class="custom-posts"><ul>';
		
		if( $categ != null ) {
			$categ_slug = $categ;
		} else { $categ_slug = null; }
		
		$week = date_i18n( 'W' );
		$month = date_i18n( 'm' );
		$year = date_i18n( 'Y' );
		
		if($popularby == 'weekly') {
			$popularpost = new WP_Query( array( 'post_type' => 'post', 'year' => $year, 'w' => $week, 'posts_per_page' => $number, 'category_name' => $categ_slug, 'meta_key' => 'wise_post_views_count', 'orderby' => 'meta_value_num', 'order' => 'DESC', 'ignore_sticky_posts' => 1  ) );
		} elseif($popularby == 'monthly') {
			$popularpost = new WP_Query( array( 'post_type' => 'post', 'year' => $year, 'monthnum' => $month, 'posts_per_page' => $number, 'category_name' => $categ_slug, 'meta_key' => 'wise_post_views_count', 'orderby' => 'meta_value_num', 'order' => 'DESC', 'ignore_sticky_posts' => 1  ) );
		} elseif($popularby == 'yearly') {
			$popularpost = new WP_Query( array( 'post_type' => 'post', 'year' => $year, 'posts_per_page' => $number, 'category_name' => $categ_slug, 'meta_key' => 'wise_post_views_count', 'orderby' => 'meta_value_num', 'order' => 'DESC', 'ignore_sticky_posts' => 1  ) );
		} else {
			$popularpost = new WP_Query( array( 'post_type' => 'post', 'posts_per_page' => $number, 'category_name' => $categ_slug, 'meta_key' => 'wise_post_views_count', 'orderby' => 'meta_value_num', 'order' => 'DESC', 'ignore_sticky_posts' => 1  ) );
		}
		
		if( $popularpost -> have_posts() ) {
			while( $popularpost -> have_posts() ) : $popularpost -> the_post();

				echo '<li>' . '<a href="' . esc_url(esc_url(get_the_permalink())) . ' "> ';
				
				if ( has_post_thumbnail() ) {
					echo '<span class="alignleft-side">';
					the_post_thumbnail('wise-side-thumb');
					echo '</span>';
				} else { null; }
				
				echo '<div class="url-popular"><h4>' . esc_html(get_the_title()) . '</h4><span class="entry-meta-popular">';
				if( function_exists('wise_posted_on') ) : wise_posted_on(); endif;
				echo '</span></div></a></li>';

			endwhile;
			wp_reset_postdata();
		} else {
			echo '<div class="wise-error-message error-widget"><p>' . wp_kses( __('No popular posts at this time', 'wise-church'), $wise_allowed_html ) . '</p></div>'; 
		}
		
		echo '</ul></div><!-- End Popular Posts -->';
		
		echo wp_kses_post($after_widget); // After widget
		
    } // End args, instance
}