<?php
/*
* Wise Custom Events Widget
*
*/
use Carbon_Fields\Widget;
use Carbon_Fields\Field;

class CustomEventsWidget extends Widget {
	
    // Register widget function. Must have the same name as the class
    function __construct() {
        $this->setup( 'wise_events_widget', esc_attr__( '#Wise CTC Custom Events', 'wise-church' ), esc_attr__( 'Displays custom events widget.', 'wise-church' ) , array(
			Field::make( 'text', 'wise_events_title', esc_attr__( 'Title:', 'wise-church' ) ),
			Field::make( 'text', 'wise_events_number', esc_attr__( 'Number of events to show:', 'wise-church' ) )->set_default_value('4'),
        ));
		$this->print_wrappers = false; // disable wrapper
    }

    // Called when rendering the widget in the front-end
    function front_end($args, $instance) {
		global $wise_allowed_html;
		$before_widget = !empty( $args['before_widget'] ) ? ( $args['before_widget'] ) : '';
		$before_title = !empty( $args['before_title'] ) ? ( $args['before_title'] ) : '';
		$after_title = !empty( $args['after_title'] ) ? ( $args['after_title'] ) : '';
		$after_widget = !empty( $args['after_widget'] ) ? ( $args['after_widget'] ) : '';
		
		$wise_events_title = !empty( $instance['wise_events_title'] ) ? ( $instance['wise_events_title'] ) : '';
		$wise_events_number = !empty( $instance['wise_events_number'] ) ? ( $instance['wise_events_number'] ) : '';
		
		echo wp_kses_post($before_widget); // Before widget
		
		if ( !empty($wise_events_title) ) { // Widget title
			echo wp_kses_post($before_title) . esc_html($wise_events_title) . wp_kses_post($after_title);
		} else {
			echo wp_kses_post($before_title) . esc_html__( 'Next Events', 'wise-church' ) . wp_kses_post($after_title);
		}
		
		// The Output
		echo '<div class="custom-posts"><ul>';
		$widget_events_args = array( // Wise Events Filter Query
			'post_type' => 'ctc_event',
			'posts_per_page' => $wise_events_number,
			'meta_query' => array(
				array( // get upcoming events only (today and future)
					'key' => '_ctc_event_end_date', // the latest date that the event goes to (could be same as start date)
					'value' => date_i18n( 'Y-m-d' ), // today's date, localized
					'compare' => '>=', // all events with start OR end date today or later
					'type' => 'DATE'
				),
			),
			'meta_key' 			=> '_ctc_event_start_date_start_time', // want earliest start date/time first
			'meta_type' 		=> 'DATETIME', // 0000-00-00 00:00:00
			'orderby'			=> 'meta_value',
			'order'				=> 'ASC', // sort from soonest to latest
			'ignore_sticky_posts' => 1
		);
		$ctc_ev_query = new WP_Query( $widget_events_args );
		
		if( $ctc_ev_query -> have_posts() ) {
			while( $ctc_ev_query -> have_posts() ) : $ctc_ev_query -> the_post();
				extract( ctfw_event_data() );
				$event_data = ctfw_event_data();
				$event_date = $event_data['start_date'];
			
				echo '<li>' . '<a href="' . esc_url(get_the_permalink()) . '">';
				
				if ( has_post_thumbnail() ) {
					echo '<span class="alignleft-side">';
					the_post_thumbnail('wise-side-thumb');
					echo '</span>';
				}
				else {
					null; 
				}
				
				echo '<div class="url-popular"><h4>' . esc_html(get_the_title()) . '</h4><span class="entry-meta-popular">';
				echo '<span class="posted-on">' . esc_html( date_i18n('F j, Y', strtotime($event_date)) ) . '</span></span></div></a></li>';
				
			endwhile;
			wp_reset_postdata();
		} else {
			echo '<div class="wise-error-message error-widget"><p>' . wp_kses( __('No upcoming events at this time', 'wise-church'), $wise_allowed_html ) . '</p></div>'; 
		}
		
		echo '</ul></div><!-- End Custom Events -->';
		
		echo wp_kses_post($after_widget); // After widget
		
    } // End args, instance
}