<?php
/*
* Additional Functions
*
*/

/*--------------------------------------------------------------
-----TABLE OF CONTENTS------------------------------------------
----------------------------------------------------------------
1. Register Widgets
2. Remove Gutenberg addition of <p> on Page Empty
3. Deregister Script for Customizer Fix
4. Page Views Count
5. Custom Code
6. Breadcrumbs
7. Social Menus
	7.1 Headhesive Social Menu
	7.2 Main Social Menu
	7.3 Footer Social Menu
8. Share Buttons
--------------------------------------------------------------*/

// Returns if wise_contents_plugin function exists
if( !function_exists('wise_contents_plugin') ) :
	function wise_contents_plugin() {
		return;
	}
endif;

/*--------------------------------------------------------------
1. Register Widgets
--------------------------------------------------------------*/
if( function_exists('carbon_fields_boot_plugin') && !function_exists('wise_load_widgets') ) :
	function wise_load_widgets() {
		// Sidebar Widgets
		include_once WISECC_PLUGIN_DIR . '/inc/wise-widgets/sidebar-widgets/wise-popular-posts.php';
		include_once WISECC_PLUGIN_DIR . '/inc/wise-widgets/sidebar-widgets/wise-recent-posts.php';
		include_once WISECC_PLUGIN_DIR . '/inc/wise-widgets/sidebar-widgets/wise-tab-popular-recent.php';
		include_once WISECC_PLUGIN_DIR . '/inc/wise-widgets/sidebar-widgets/wise-about.php';
		include_once WISECC_PLUGIN_DIR . '/inc/wise-widgets/sidebar-widgets/wise-dashboard-user.php';
		include_once WISECC_PLUGIN_DIR . '/inc/wise-widgets/sidebar-widgets/wise-script.php';
		include_once WISECC_PLUGIN_DIR . '/inc/wise-widgets/sidebar-widgets/wise-text-alert.php';
		include_once WISECC_PLUGIN_DIR . '/inc/wise-widgets/sidebar-widgets/wise-sitelinks.php';
		include_once WISECC_PLUGIN_DIR . '/inc/wise-widgets/sidebar-widgets/wise-social-media-footer.php';
		include_once WISECC_PLUGIN_DIR . '/inc/wise-widgets/sidebar-widgets/wise-subscribe-footer.php';
		include_once WISECC_PLUGIN_DIR . '/inc/wise-widgets/sidebar-widgets/wise-subscribe-sidebar.php';
		if ( class_exists( 'Church_Theme_Content' ) && current_theme_supports( 'church-theme-content' ) ) {
			include_once WISECC_PLUGIN_DIR . '/inc/wise-widgets/sidebar-widgets/wise-ctc-custom-event.php';
			include_once WISECC_PLUGIN_DIR . '/inc/wise-widgets/sidebar-widgets/wise-ctc-popular-sermon.php';
			include_once WISECC_PLUGIN_DIR . '/inc/wise-widgets/sidebar-widgets/wise-ctc-recent-sermon.php';
			include_once WISECC_PLUGIN_DIR . '/inc/wise-widgets/sidebar-widgets/wise-ctc-tab-sermon.php';
		}

		// Register Widgets
		if( class_exists('AboutWidget') ) : register_widget('AboutWidget'); endif;
        if ( class_exists( 'Church_Theme_Content' ) && current_theme_supports( 'church-theme-content' ) ) {
            if( class_exists('CustomEventsWidget') ) : register_widget('CustomEventsWidget'); endif;
            if( class_exists('PopularSermonsWidget') ) : register_widget('PopularSermonsWidget'); endif;
            if( class_exists('RecentSermonsWidget') ) : register_widget('RecentSermonsWidget'); endif;
            if( class_exists('TabSermonsWidget') ) : register_widget('TabSermonsWidget'); endif;
        }
		if( class_exists('DashboardUserWidget') ) : register_widget('DashboardUserWidget'); endif;
		if( class_exists('PopularPostsWidget') ) : register_widget('PopularPostsWidget'); endif;
		if( class_exists('RecentPostsWidget') ) : register_widget('RecentPostsWidget'); endif;
		if( class_exists('WiseScriptWidget') ) : register_widget('WiseScriptWidget'); endif;
		if( class_exists('FooterSitelinksWidget') ) : register_widget('FooterSitelinksWidget'); endif;
		if( class_exists('SocialMediaFooterWidget') ) : register_widget('SocialMediaFooterWidget'); endif;
		if( class_exists('SubscribeFooterWidget') ) : register_widget('SubscribeFooterWidget'); endif;
		if( class_exists('SubscribeSidebarWidget') ) : register_widget('SubscribeSidebarWidget'); endif;
		if( class_exists('TabPostsWidget') ) : register_widget('TabPostsWidget'); endif;
		if( class_exists('WiseTextAlertWidget') ) : register_widget('WiseTextAlertWidget'); endif;
	}
	add_action('widgets_init', 'wise_load_widgets');
endif;

/*--------------------------------------------------------------
2. Remove Gutenberg addition of <p> on Page Empty
--------------------------------------------------------------*/
if( !function_exists('wise_fix_gutenberg_content') ) :
    function wise_fix_gutenberg_content() {
        if( is_page_template('page-empty.php') ) : 
            remove_filter ('the_content', 'wpautop'); the_content();
        endif;
    }
endif;

/*--------------------------------------------------------------
3. Deregister Script for Customizer Fix
--------------------------------------------------------------*/
if( !function_exists('wise_deregister_script') ) :
	function wise_deregister_script() {
		wp_deregister_script( 'sticky-kit' ); // Disable Sticky Kit
	}
	add_action( 'wp_enqueue_scripts', 'wise_deregister_script' );
endif;

/*--------------------------------------------------------------
4. Page Views Count
--------------------------------------------------------------*/
/* REST API Page Count Views */
// Page views count function
if ( !function_exists( 'wise_get_post_views' ) ) :
	// Post view count
	function wise_get_post_views($postID){
        $count_key = 'wise_post_views_count';
        $count = get_post_meta($postID, $count_key, true);
        if($count == 0) {
            echo '<span ' . 'id="wiseviews-' . esc_attr($postID) . '"' . 'class="post-views">0</span>';
        } else {
            echo '<span ' . 'id="wiseviews-' . esc_attr($postID) . '"' . 'class="post-views"></span>';
        }
        wise_page_views_script(); // JavaScript
	}
endif;

// Page views count from wise_post_views_count custom field
if ( !function_exists( 'wise_count_view' ) ) :
    function wise_count_view( $data ) {
        $post = get_post( $data['id'] );

        if ( empty( $post ) ) {
            return new WP_Error( 'wise_post_not_found', 'Invalid post ID', array( 'status' => 404 ) );
        }

        $postID = $post->ID;
        $count_key = 'wise_post_views_count';  
        $count = get_post_meta($postID, $count_key, true);

        if( $count == '' ) {
            $count = array("count_view" => 0);
			delete_post_meta($postID, $count_key);
			add_post_meta( $postID, $count_key, 0 );
        } else {
            $counts = array("count_view" => $count);
        }

        return new WP_REST_Response($counts);
    }

    add_action( 'rest_api_init', function () {
        register_rest_route( 'wise/v2', '/countview/(?P<id>\d+)', array(
            'methods' => 'GET',
            'callback' => 'wise_count_view',
            'permission_callback' => '__return_true',
        ) );
    } );
endif;

// Page views count incremented from wise_post_views_count custom field
if ( !function_exists( 'wise_count_viewplus' ) ) :
    function wise_count_viewplus( $data ) {
        $post = get_post( $data['id'] );

        if ( empty( $post ) ) {
            return new WP_Error( 'wise_post_not_found', 'Invalid post ID', array( 'status' => 404 ) );
        }

        $postID = $post->ID;
        $count_key = 'wise_post_views_count';
        $count = get_post_meta($postID, $count_key, true);

        if( $count == '' ) {
            $count = array("count_view" => 0);
			delete_post_meta($postID, $count_key);
			add_post_meta( $postID, $count_key, 0 );
        } else {
            $count++;
            update_post_meta($postID, $count_key, $count);
            $counts = array("count_view" => $count);
        }

        return new WP_REST_Response($counts);
    }

    add_action( 'rest_api_init', function () {
        register_rest_route( 'wise/v2', '/countviewplus/(?P<id>\d+)', array(
            'methods' => 'GET',
            'callback' => 'wise_count_viewplus',
            'permission_callback' => '__return_true',
        ) );
    } );

    /* if php is used for counting
        add_action( 'wp_head', 'wise_count_viewplus');
    */
endif;

// JavaScript code for page views count
if ( !function_exists( 'wise_page_views_script' ) ) :
    function wise_page_views_script() {
        $postID = get_the_ID();
        $count_key = 'wise_post_views_count';
        $count = get_post_meta($postID, $count_key, true);

        // Use PHP if REST API is not working
        if($count == '') {
            $count_fallback = 0;
        } else {
            $thousand = 1000;
            $million = 1000 * $thousand;
            $billion = 1000 * $million;
            $trillion = 1000 * $billion;
    
            if( ($count >= $thousand) && ($count < $million) ) {
                $count = round( $count/$thousand, 2 );
                $count_fallback = esc_attr($count) . esc_html( 'K', 'wise-church' );
            } elseif( ($count >= $million) && ($count < $billion) ) {
                $count = round( $count/$million, 2 );
                $count_fallback = esc_attr($count) . esc_html( 'M', 'wise-church' );
            } elseif( ($count >= $billion) && ($count < $trillion) ) {
                $count = round( $count/$billion, 2 );
                $count_fallback = esc_attr($count) . esc_html( 'B', 'wise-church' );
            } else {
                $count_fallback = esc_attr($count);
            }
        }
        
        // REST API URL
        $wise_home_url = home_url('/');
        if(is_single()) {
            $wise_api_page_count_url = $wise_home_url . 'wp-json/wise/v2/countviewplus/' . $postID;
        } else {
            $wise_api_page_count_url = $wise_home_url . 'wp-json/wise/v2/countview/' . $postID;
        }
        ?><script>
        var url = "<?php echo esc_js($wise_api_page_count_url); ?>";
        
        fetch(url)
        .then(res => res.json())
        .then(json => {
            var data = json.count_view;
            var thousand = 1000;
            var million = 1000 * thousand;
            var billion = 1000 * million;
            var trillion = 1000 * billion;
            var dataFallback = '<?php echo esc_js($count_fallback); ?>';

            if( !isNaN(data) ) {
                if( (data >= thousand) && (data < million) ) {
                    var dataThousand = ( data / thousand ).toFixed(2);
                    var result = `${dataThousand}<?php echo esc_html( 'K', 'wise-church' ) ?>`;
                    document.getElementById('<?php echo 'wiseviews-' . esc_js($postID); ?>').innerHTML = result;
                } else if( (data >= million) && (data < billion) ) {
                    var dataMillion = ( data / million ).toFixed(2);
                    var result = `${dataMillion}<?php echo esc_html( 'M', 'wise-church' ) ?>`;
                    document.getElementById('<?php echo 'wiseviews-' . esc_js($postID); ?>').innerHTML = result;
                } else if( (data >= billion) && (data < trillion) ) {
                    var dataBillion = ( data / billion ).toFixed(2);
                    var result = `${dataBillion}<?php echo esc_html( 'B', 'wise-church' ) ?>`;
                    document.getElementById('<?php echo 'wiseviews-' . esc_js($postID); ?>').innerHTML = result;
                } else {
                    document.getElementById('<?php echo 'wiseviews-' . esc_js($postID); ?>').innerHTML = data;
                }
            } else {
                document.getElementById('<?php echo 'wiseviews-' . esc_js($postID); ?>').innerHTML = dataFallback;
            }
            
        })
        .catch(err => {
            console.error(err.message);
        });
        </script><?php
    }
endif;

/*--------------------------------------------------------------
5. Custom Code
--------------------------------------------------------------*/
if( !function_exists('wise_before_head') ) :
	function wise_before_head() {
		$wise_before_head = get_theme_mod('wise_code_before_head');
		echo !empty($wise_before_head) ? $wise_before_head : null;
	}
endif;

if( !function_exists('wise_after_body') ) :
	function wise_after_body() {
		$wise_after_body = get_theme_mod('wise_code_after_body');
		echo !empty($wise_after_body) ? $wise_after_body : null;
	}
endif;

if( !function_exists('wise_before_body') ) :
	function wise_before_body() {
		$wise_before_body = get_theme_mod('wise_code_before_body');
		echo !empty($wise_before_body) ? $wise_before_body : null;
	}
endif;

/*--------------------------------------------------------------
6. Breadcrumbs
--------------------------------------------------------------*/
if ( ! function_exists( 'wise_breadcrumbs' ) ) :
	function wise_breadcrumbs( $args = array() ) {
		// Do not display on the homepage
		if ( is_front_page() ) {
			return;
		}
		// Set default arguments
		$defaults = array(
			'separator_icon'      => '&rsaquo;',
			'breadcrumbs_id'      => 'breadcrumbs',
			'breadcrumbs_classes' => 'breadcrumb-trail breadcrumbs',
			'home_title'          => esc_attr__( 'Home', 'wise-church' )
		);
		// Parse any arguments added
		$args = apply_filters( 'wise_breadcrumbs_args', wp_parse_args( $args, $defaults ) );
		// Set variable for adding separator markup
		$separator = '<span class="separator"> ' . $args['separator_icon'] . ' </span>';
		// Get global post object
		global $post;
		/* Begin Markup */
		// Open the breadcrumbs
		$html = '<div id="' . esc_attr( $args['breadcrumbs_id'] ) . '" class="' . esc_attr( $args['breadcrumbs_classes']) . '">';
		// Add Homepage link & separator (always present)
		$html .= '<span class="item-home"><a class="bread-link bread-home" href="' . esc_url( get_home_url('/') ) . '" title="' . esc_attr( $args['home_title'] ) . '">' . esc_attr( $args['home_title'] ) . '</a></span>';
		$html .= $separator;
		// Post
		if ( is_singular( 'post' ) ) {
			// Get post category info
			$category = get_the_category();
			// Get category values
			$category_values = array_values( $category );
			// Get last category post is in
			$last_category = end( $category_values );
			// Get parent categories
			$cat_parents = rtrim( get_category_parents( $last_category->term_id, true, ',' ), ',' );
			// Convert into array
			$cat_parents = explode( ',', $cat_parents );
			// Loop through parent categories and add to breadcrumb trail
			foreach ( $cat_parents as $parent ) {
				$html .= '<span class="item-cat">' . wp_kses( $parent, wp_kses_allowed_html( 'a' ) ) . '</span>';
				$html .= $separator;
			}
			// add name of Post
			$html .= '<span class="item-current item-' . $post->ID . '"><span class="bread-current bread-' . $post->ID . '" title="' . get_the_title() . '">' . get_the_title() . '</span></span>';
		} elseif ( is_singular( 'page' ) ) { // Page
			// if page has a parent page
			if ( $post->post_parent ) {
				// Get all parents
				$parents = get_post_ancestors( $post->ID );
				// Sort parents into the right order
				$parents = array_reverse( $parents );
				// Add each parent to markup
				foreach ( $parents as $parent ) {
					$html .= '<span class="item-parent item-parent-' . esc_attr( $parent ) . '"><a class="bread-parent bread-parent-' . esc_attr( $parent ) . '" href="' . get_permalink( $parent ) . '" title="' . get_the_title( $parent ) . '">' . get_the_title( $parent ) . '</a></span>';
					$html .= $separator;
				}
			}
			// Current page
			$html .= '<span class="item-current item-' . $post->ID . '"><span title="' . get_the_title() . '"> ' . get_the_title() . '</span></span>';
		} elseif ( is_singular( 'attachment' ) ) { // Attachment
			// Get the parent post ID
			$parent_id = $post->post_parent;
			// Get the parent post title
			$parent_title = get_the_title( $parent_id );
			// Get the parent post permalink
			$parent_permalink = get_permalink( $parent_id );
			// Add markup
			$html .= '<span class="item-parent"><a class="bread-parent" href="' . esc_url( $parent_permalink ) . '" title="' . esc_attr( $parent_title ) . '">' . esc_attr( $parent_title ) . '</a></span>';
			$html .= $separator;
			// Add name of attachment
			$html .= '<span class="item-current item-' . $post->ID . '"><span title="' . get_the_title() . '"> ' . get_the_title() . '</span></span>';
		} elseif ( is_singular() ) { // Custom Post Types
			// Get the post type
			$post_type = get_post_type();
			// Get the post object
			$post_type_object = get_post_type_object( $post_type );
			// Get the post type archive
			$post_type_archive = get_post_type_archive_link( $post_type );
			// Add taxonomy link and separator
			$html .= '<span class="item-cat item-custom-post-type-' . esc_attr( $post_type ) . '"><a class="bread-cat bread-custom-post-type-' . esc_attr( $post_type ) . '" href="' . esc_url( $post_type_archive ) . '" title="' . esc_attr( $post_type_object->labels->name ) . '">' . esc_attr( $post_type_object->labels->name ) . '</a></span>';
			$html .= $separator;
			// Add name of Post
			$html .= '<span class="item-current item-' . $post->ID . '"><span class="bread-current bread-' . $post->ID . '" title="' . $post->post_title . '">' . $post->post_title . '</span></span>';
		} elseif ( is_category() ) { // Category
			// Get category object
			$parent = get_queried_object()->category_parent;
			// If there is a parent category...
			if ( $parent !== 0 ) {
				// Get the parent category object
				$parent_category = get_category( $parent );
				// Get the link to the parent category
				$category_link = get_category_link($parent);
				// Output the markup for the parent category item
				$html .= '<span class="item-parent item-parent-' . esc_attr( $parent_category->slug ) . '"><a class="bread-parent bread-parent-' . esc_attr( $parent_category->slug ) . '" href="' . esc_url( $category_link ) . '" title="' . esc_attr( $parent_category->name ) . '">' . esc_attr( $parent_category->name ) . '</a></span>';
				$html .= $separator;
			}
			// Add category markup
			$html .= '<span class="item-current item-cat"><span class="bread-current bread-cat" title="' . $post->ID . '">' . single_cat_title( '', false ) . '</span></span>';
		} elseif ( is_tag() ) { // Tag
			// Add tag markup
			$html .= '<span class="item-current item-tag"><span class="bread-current bread-tag">' . single_tag_title( '', false ) . '</span></span>';
		} elseif ( is_author() ) { // Author
			// Add author markup
			$html .= '<span class="item-current item-author"><span class="bread-current bread-author">' . get_queried_object()->display_name . '</span></span>';
		} elseif ( is_day() ) { // Day
			// Add day markup
			$html .= '<span class="item-current item-day"><span class="bread-current bread-day">' . get_the_date() . '</span></span>';
		} elseif ( is_month() ) { // Month
			// Add month markup
			$html .= '<span class="item-current item-month"><span class="bread-current bread-month">' . get_the_date( 'F Y' ) . '</span></span>';
		} elseif ( is_year() ) { // Year
			// Add year markup
			$html .= '<span class="item-current item-year"><span class="bread-current bread-year">' . get_the_date( 'Y' ) . '</span></span>';
		} elseif ( is_archive() && is_tax() ) { // Custom Taxonomy
           // If post is a custom post type
            $post_type = get_post_type();              
            // If it is a custom post type display name and link
            if($post_type != 'post') {                  
                $post_type_object = get_post_type_object($post_type);
                $post_type_archive = get_post_type_archive_link($post_type);              
                $html .= '<span class="item-cat item-custom-post-type-' . $post_type . '"><a class="bread-cat bread-custom-post-type-' . $post_type . '" href="' . $post_type_archive . '" title="' . $post_type_object->labels->name . '">' . $post_type_object->labels->name . '</a></span>';
                $html .= $separator;              
            }              
            $custom_tax_name = get_queried_object()->name;
            $html .= '<span class="item-current item-archive"><strong class="bread-current bread-archive">' . $custom_tax_name . '</strong></span>';			
		/* CTC Breadcrumbs Settings */
		} elseif ( class_exists( 'Church_Theme_Content' ) && current_theme_supports( 'church-theme-content' ) && is_archive() && !is_tax() ) {
			$post_type = get_post_type();
			$ctc_tax_name = get_post_type_object($post_type)->labels->name;
			$html .= '<span class="item-current item-archive"><span class="bread-current bread-archive">' . esc_attr($ctc_tax_name) . '</span></span>';			
		} elseif ( is_search() ) { // Search
			// Add search markup
			$html .= '<span class="item-current item-search"><span class="bread-current bread-search">' . esc_html_e('Search results for: ', 'wise-church') . get_search_query() . '</span></span>';
		} elseif ( is_404() ) { // 404
			// Add 404 markup
			$html .= '<span>' . esc_html__('Error 404', 'wise-church') . '</span>';
		} elseif ( is_home() ) { // blog when not on homepage
			$html .= '<span>' . get_the_title( get_option('page_for_posts' ) ) . '</span>';
		}
		// Close breadcrumb container
		$html .= '</div>';
		$html = apply_filters( 'wise_breadcrumbs_filter', $html );
		echo wp_kses_post( $html );
	}
endif;

/*--------------------------------------------------------------
7. Social Menus
--------------------------------------------------------------*/
	/*--------------------------------------------------------------
	7.1 Headhesive Social Menu
	--------------------------------------------------------------*/
	if( !function_exists('wise_headhesive_social_menu') && class_exists( 'FortAwesome\FontAwesome_Loader' ) ) :
		function wise_headhesive_social_menu() { ?>
			<div class="social-like-wrapper">
				<div class="social-like-headhesive" id="share-top">
				  <ul class="social-links-headhesive clear">
				  
					<?php
						if (get_theme_mod('wise_soc_rss_links') != null) { 
							echo '<li><a href="';
							echo esc_url(get_theme_mod('wise_soc_rss_links'));
							echo '" target="_blank"><i class="fa fa-rss" aria-hidden="true"></i></a></li>';
						} else {
							null;
						}

						if (get_theme_mod('wise_soc_fb_links') != null) { 
							echo '<li><a href="';
							echo esc_url(get_theme_mod('wise_soc_fb_links'));
							echo '" target="_blank"><i class="fa-brands fa-facebook-f" aria-hidden="true"></i></a></li>';
						} else {
							null;
						}

						if (get_theme_mod('wise_soc_twitter_links') != null) { 
							echo '<li><a href="';
							echo esc_url(get_theme_mod('wise_soc_twitter_links'));
							echo '" target="_blank"><i class="fa-brands fa-x-twitter" aria-hidden="true"></i></a></li>';
						} else {
							null;
						}

						if (get_theme_mod('wise_soc_ins_links') != null) { 
							echo '<li><a href="';
							echo esc_url(get_theme_mod('wise_soc_ins_links'));
							echo '" target="_blank"><i class="fa-brands fa-instagram" aria-hidden="true"></i></a></li>';
						} else {
							null;
						}

						if (get_theme_mod('wise_soc_tiktok_links') != null) { 
							echo '<li><a href="';
							echo esc_url(get_theme_mod('wise_soc_tiktok_links'));
							echo '" target="_blank"><i class="fa-brands fa-tiktok" aria-hidden="true"></i></a></li>';
						} else {
							null;
						}

						if (get_theme_mod('wise_soc_yt_links') != null) { 
							echo '<li><a href="';
							echo esc_url(get_theme_mod('wise_soc_yt_links'));
							echo '" target="_blank"><i class="fa-brands fa-youtube" aria-hidden="true"></i></a></li>';
						} else {
							null;
						}
						
						if (get_theme_mod('wise_soc_vim_links') != null) { 
							echo '<li><a href="';
							echo esc_url(get_theme_mod('wise_soc_vim_links'));
							echo '" target="_blank"><i class="fa-brands fa-vimeo" aria-hidden="true"></i></a></li>';
						} else {
							null;
						}
						
						if (get_theme_mod('wise_soc_in_links') != null) { 
							echo '<li><a href="';
							echo esc_url(get_theme_mod('wise_soc_in_links'));
							echo '" target="_blank"><i class="fa-brands fa-linkedin" aria-hidden="true"></i></a></li>';
						} else {
							null;
						}
						
						if (get_theme_mod('wise_soc_pin_links') != null) { 
							echo '<li><a href="';
							echo esc_url(get_theme_mod('wise_soc_pin_links'));
							echo '" target="_blank"><i class="fa-brands fa-pinterest" aria-hidden="true"></i></a></li>';
						} else {
							null;
						}
						
						if (get_theme_mod('wise_soc_vk_links') != null) { 
							echo '<li><a href="';
							echo esc_url(get_theme_mod('wise_soc_vk_links'));
							echo '" target="_blank"><i class="fa-brands fa-vk" aria-hidden="true"></i></a></li>';
						} else {
							null;
						}
					?>

				  </ul>
				</div><!--End Social Links Headhesive-->
			</div><!--End Social Like Wrapper Headhesive--><?php
		}
	endif;

	/*--------------------------------------------------------------
	7.2 Main Social Menu
	--------------------------------------------------------------*/
	if( !function_exists('wise_main_social_menu') && class_exists( 'FortAwesome\FontAwesome_Loader' ) ) :
		function wise_main_social_menu() { ?>
			<div class="social-top">
			  <ul class="social-links-top clear">
				
				<?php
					if (get_theme_mod('wise_soc_rss_links') != null) { 
						echo '<li><a href="';
						echo esc_url(get_theme_mod('wise_soc_rss_links'));
						echo '" target="_blank"><i class="fa fa-rss" aria-hidden="true"></i></a></li>';
					} else {
						echo '';
					}

					if (get_theme_mod('wise_soc_fb_links') != null) { 
						echo '<li><a href="';
						echo esc_url(get_theme_mod('wise_soc_fb_links'));
						echo '" target="_blank"><i class="fa-brands fa-facebook-f" aria-hidden="true"></i></a></li>';
					} else {
						null;
					}

					if (get_theme_mod('wise_soc_twitter_links') != null) { 
						echo '<li><a href="';
						echo esc_url(get_theme_mod('wise_soc_twitter_links'));
						echo '" target="_blank"><i class="fa-brands fa-x-twitter" aria-hidden="true"></i></a></li>';
					} else {
						null;
					}

					if (get_theme_mod('wise_soc_ins_links') != null) { 
						echo '<li><a href="';
						echo esc_url(get_theme_mod('wise_soc_ins_links'));
						echo '" target="_blank"><i class="fa-brands fa-instagram" aria-hidden="true"></i></a></li>';
					} else {
						null;
					}

					if (get_theme_mod('wise_soc_tiktok_links') != null) { 
						echo '<li><a href="';
						echo esc_url(get_theme_mod('wise_soc_tiktok_links'));
						echo '" target="_blank"><i class="fa-brands fa-tiktok" aria-hidden="true"></i></a></li>';
					} else {
						null;
					}

					if (get_theme_mod('wise_soc_yt_links') != null) { 
						echo '<li><a href="';
						echo esc_url(get_theme_mod('wise_soc_yt_links'));
						echo '" target="_blank"><i class="fa-brands fa-youtube" aria-hidden="true"></i></a></li>';
					} else {
						null;
					}
					
					if (get_theme_mod('wise_soc_vim_links') != null) { 
						echo '<li><a href="';
						echo esc_url(get_theme_mod('wise_soc_vim_links'));
						echo '" target="_blank"><i class="fa-brands fa-vimeo" aria-hidden="true"></i></a></li>';
					} else {
						null;
					}

					if (get_theme_mod('wise_soc_in_links') != null) { 
						echo '<li><a href="';
						echo esc_url(get_theme_mod('wise_soc_in_links'));
						echo '" target="_blank"><i class="fa-brands fa-linkedin" aria-hidden="true"></i></a></li>';
					} else {
						null;
					}
					
					if (get_theme_mod('wise_soc_pin_links') != null) { 
						echo '<li><a href="';
						echo esc_url(get_theme_mod('wise_soc_pin_links'));
						echo '" target="_blank"><i class="fa-brands fa-pinterest" aria-hidden="true"></i></a></li>';
					} else {
						null;
					}
					
					if (get_theme_mod('wise_soc_vk_links') != null) { 
						echo '<li><a href="';
						echo esc_url(get_theme_mod('wise_soc_vk_links'));
						echo '" target="_blank"><i class="fa-brands fa-vk" aria-hidden="true"></i></a></li>';
					} else {
						null;
					}
				?>

			  </ul>
			</div><!-- End Social-Top --><?php
		}
	endif;

	/*--------------------------------------------------------------
	7.3 Footer Social Menu
	--------------------------------------------------------------*/
	if( !function_exists('wise_footer_social_menu') && class_exists( 'FortAwesome\FontAwesome_Loader' ) ) :
		function wise_footer_social_menu() { ?>
			<div class="<?php if( get_theme_mod( 'wise_footer_style' ) == 'single' ) { echo 'social-cover-footer '; } else { echo ''; } ?>clear">
				<?php
					echo '<ul class="social-links-footer">';

					if (get_theme_mod('wise_soc_rss_links') != null) { 
						echo '<li><a href="';
						echo esc_url(get_theme_mod('wise_soc_rss_links'));
						echo '" target="_blank"><i class="fa fa-rss" aria-hidden="true"></i></a></li>';
					} else {
						null;
					}

					if (get_theme_mod('wise_soc_fb_links') != null) { 
						echo '<li><a href="';
						echo esc_url(get_theme_mod('wise_soc_fb_links'));
						echo '" target="_blank"><i class="fa-brands fa-facebook-f" aria-hidden="true"></i></a></li>';
					} else {
						null;
					}

					if (get_theme_mod('wise_soc_twitter_links') != null) { 
						echo '<li><a href="';
						echo esc_url(get_theme_mod('wise_soc_twitter_links'));
						echo '" target="_blank"><i class="fa-brands fa-x-twitter" aria-hidden="true"></i></a></li>';
					} else {
						null;
					}

					if (get_theme_mod('wise_soc_ins_links') != null) { 
						echo '<li><a href="';
						echo esc_url(get_theme_mod('wise_soc_ins_links'));
						echo '" target="_blank"><i class="fa-brands fa-instagram" aria-hidden="true"></i></a></li>';
					} else {
						null;
					}

					if (get_theme_mod('wise_soc_tiktok_links') != null) { 
						echo '<li><a href="';
						echo esc_url(get_theme_mod('wise_soc_tiktok_links'));
						echo '" target="_blank"><i class="fa-brands fa-tiktok" aria-hidden="true"></i></a></li>';
					} else {
						null;
					}

					if (get_theme_mod('wise_soc_yt_links') != null) { 
						echo '<li><a href="';
						echo esc_url(get_theme_mod('wise_soc_yt_links'));
						echo '" target="_blank"><i class="fa-brands fa-youtube" aria-hidden="true"></i></a></li>';
					} else {
						null;
					}
					
					if (get_theme_mod('wise_soc_vim_links') != null) { 
						echo '<li><a href="';
						echo esc_url(get_theme_mod('wise_soc_vim_links'));
						echo '" target="_blank"><i class="fa-brands fa-vimeo" aria-hidden="true"></i></a></li>';
					} else {
						null;
					}
					
					if (get_theme_mod('wise_soc_in_links') != null) { 
						echo '<li><a href="';
						echo esc_url(get_theme_mod('wise_soc_in_links'));
						echo '" target="_blank"><i class="fa-brands fa-linkedin" aria-hidden="true"></i></a></li>';
					} else {
						null;
					}
					
					if (get_theme_mod('wise_soc_pin_links') != null) { 
						echo '<li><a href="';
						echo esc_url(get_theme_mod('wise_soc_pin_links'));
						echo '" target="_blank"><i class="fa-brands fa-pinterest" aria-hidden="true"></i></a></li>';
					} else {
						null;
					}
					
					if (get_theme_mod('wise_soc_vk_links') != null) { 
						echo '<li><a href="';
						echo esc_url(get_theme_mod('wise_soc_vk_links'));
						echo '" target="_blank"><i class="fa-brands fa-vk" aria-hidden="true"></i></a></li>';
					} else {
						null;
					}

				echo '</ul>';
				?>
			</div><?php
		}
	endif;

/*--------------------------------------------------------------
8. Share Buttons
--------------------------------------------------------------*/
if( !function_exists('wise_share_buttons') && class_exists( 'FortAwesome\FontAwesome_Loader' ) ) :
	function wise_share_buttons() {
		if( get_theme_mod('wise_disable_share_buttons') == false ) {
			global $post;
			$page_share = is_page() ? ' page-share-entry-meta' : '';
			echo '<div class="share-entry-meta' . esc_attr($page_share) . '"><ul>';
			$share_title = str_replace( ' ', '%20', get_the_title() );
			$share_url = esc_url(esc_url(get_the_permalink()));
			$share_img = wp_get_attachment_url( get_post_thumbnail_id($post->ID) );
			
			$share_fb = 'https://www.facebook.com/sharer/sharer.php?u=' . $share_url;
			$share_tw = 'https://twitter.com/intent/tweet?text=' . $share_title .'&amp;url='. $share_url .'&amp;via=' . get_theme_mod('wise_twitter_acc');
			$share_ml = 'mailto:?Subject=' . $share_title . '&amp;Body=' . $share_url;
			$share_ln = 'https://www.linkedin.com/shareArticle?mini=true&url=' . $share_url;
			$share_pt = 'https://pinterest.com/pin/create/button/?url=' . $share_url . '&media=' . $share_img;
			
			echo '<li class="soc-facebook"><a class="my-post-like" data-id="' . get_the_ID() . '" href="' . esc_url($share_fb) . '" target="_blank"><span class="soc-share">' . esc_html__('Share','wise-church') . ' </span><span class="soc-on">' . esc_html__('on Facebook', 'wise-church') . '</span></a></li>';
			echo '<li class="soc-twitter"><a href="' . esc_url($share_tw) . '" target="_blank"><span class="soc-share">' . esc_html__('Share','wise-church') . ' </span><span class="soc-on">' . esc_html__('on X', 'wise-church') . '</span></a></li>';	
			echo '<li class="soc-linkedin"><a href="' . esc_url($share_ln) . '" target="_blank"><span class="screen-reader-text">' . esc_html__('LinkedIn','wise-church') . '</span></a></li>';	
			echo '<li class="soc-pint"><a href="' . esc_url($share_pt) . '" target="_blank"><span class="screen-reader-text">' . esc_html__('Pinterest','wise-church') . '</span></a></li>';
			echo '<li class="soc-mail"><a href="' . esc_url($share_ml) . '" target="_blank"><span class="screen-reader-text">' . esc_html__('Mail','wise-church') . '</span></a></li>';
			echo '</ul></div>';
		} else {
			return;
		}
	}
endif;