<?php
/*
* Wise Tab Posts Widget
*
*/
use Carbon_Fields\Widget;
use Carbon_Fields\Field;

class TabPostsWidget extends Widget {
	
    // Register widget function. Must have the same name as the class
    function __construct() {
		global $wp_cats;
        $this->setup( 'wise_tab_posts_widget', esc_attr__( '#Wise Tab Posts', 'wise-church' ), esc_attr__( 'Displays tab popular and recent posts widget.', 'wise-church' ) , array(
			// Popular Posts
			Field::make( 'separator', 'wise_pop_style_options_tab', esc_attr__( 'Popular Posts Tab', 'wise-church' ) ),
			Field::make( 'text', 'wise_pop_title_tab', esc_attr__( 'Title:', 'wise-church' ) ),
			Field::make( 'text', 'wise_pop_number_tab', esc_attr__( 'Number of posts to show:', 'wise-church' ) )
				->set_default_value('4'),
			Field::make( 'select', 'wise_pop_categ_tab', esc_attr__( 'Select Category:', 'wise-church' ) )
				->add_options($wp_cats),
			Field::make( 'radio', 'wise_pop_popularby_tab', esc_attr__( 'Popular posts created on:', 'wise-church' ) )
				->add_options(array(
					'weekly' => esc_attr__( 'This Week', 'wise-church' ),
					'monthly' => esc_attr__( 'This Month', 'wise-church' ),
					'yearly' => esc_attr__( 'This Year', 'wise-church' ),
					'alltime' => esc_attr__( 'All Time', 'wise-church' ),
				))->set_default_value('alltime'),
			// Recent Posts
			Field::make('separator', 'wise_rec_style_options_tab', esc_attr__( 'Recent Posts Tab', 'wise-church' ) ),
			Field::make('text', 'wise_rec_title_tab', esc_attr__( 'Title:', 'wise-church' ) ),
			Field::make('text', 'wise_rec_number_tab', esc_attr__( 'Number of posts to show:', 'wise-church' ) )
				->set_default_value('4'),
			Field::make('select', 'wise_rec_categ_tab', esc_attr__( 'Select Category:', 'wise-church' ) )
				->add_options($wp_cats),
			Field::make('select', 'wise_rec_orderby_tab', esc_attr__( 'Order by:', 'wise-church' ) )
				->add_options(array(
					'date' => esc_attr__( 'Date', 'wise-church' ),
					'rand' => esc_attr__( 'Random', 'wise-church' ),
					'title' => esc_attr__( 'Title', 'wise-church' ),
					'comment_count' => esc_attr__( 'Comment', 'wise-church' ),
				))->set_default_value('date')
        ));
		$this->print_wrappers = false; // disable wrapper
    }

    // Called when rendering the widget in the front-end
    function front_end($args, $instance) {
		global $wise_allowed_html;

		// Popular Posts
		$pop_title = !empty( $instance['wise_pop_title_tab'] ) ? $instance['wise_pop_title_tab'] : '';
		$pop_number = !empty( $instance['wise_pop_number_tab'] ) ? $instance['wise_pop_number_tab'] : '';
		$pop_categ = !empty( $instance['wise_pop_categ_tab'] ) ? $instance['wise_pop_categ_tab'] : '';
		$pop_popularby = !empty( $instance['wise_pop_popularby_tab'] ) ? $instance['wise_pop_popularby_tab'] : '';
		
		// Recent Posts
		$rec_title = !empty( $instance['wise_rec_title_tab'] ) ? $instance['wise_rec_title_tab'] : '';
		$rec_number = !empty( $instance['wise_rec_number_tab'] ) ? $instance['wise_rec_number_tab'] : '';
		$rec_categ = !empty( $instance['wise_rec_categ_tab'] ) ? $instance['wise_rec_categ_tab'] : '';
		$rec_order = !empty( $instance['wise_rec_orderby_tab'] ) ? $instance['wise_rec_orderby_tab'] : '';
		
		if ( !empty($pop_title) ) { // Popular Tab Title
			$pop_title_output = $pop_title;
		} else {
			$pop_title_output = esc_attr__( 'Most Popular', 'wise-church' );
		}
		
		if ( !empty($rec_title) ) { // Recent Tab Title
			$rec_title_output = $rec_title;
		} else {
			$rec_title_output = esc_attr__( 'Most Recent', 'wise-church' );
		}
		
		// The Output ?>
		<div class="wise-tabs">
			<div class="widget tab-sidebar">
				<ul class="wise-nav">
					<li><a href="#popular"><?php echo esc_html($pop_title_output); ?></a></li>
					<li><a href="#recent"><?php echo esc_html($rec_title_output); ?></a></li>
				</ul>

				<div class="tab-content">
					<div id="popular">
						<?php // Output for Popular Posts
						echo '<div class="custom-posts"><ul>';
						
						if( $pop_categ != null ) {
							$pop_categ_slug = $pop_categ;
						} else { $pop_categ_slug = null; }
						
						$week = date_i18n( 'W' );
						$month = date_i18n( 'm' );
						$year = date_i18n( 'Y' );
						
						if($pop_popularby == 'weekly') {
							$popularpost = new WP_Query( array( 'post_type' => 'post', 'year' => $year, 'w' => $week, 'posts_per_page' => $pop_number, 'category_name' => $pop_categ_slug, 'meta_key' => 'wise_post_views_count', 'orderby' => 'meta_value_num', 'order' => 'DESC', 'ignore_sticky_posts' => 1  ) );
						} elseif($pop_popularby == 'monthly') {
							$popularpost = new WP_Query( array( 'post_type' => 'post', 'year' => $year, 'monthnum' => $month, 'posts_per_page' => $pop_number, 'category_name' => $pop_categ_slug, 'meta_key' => 'wise_post_views_count', 'orderby' => 'meta_value_num', 'order' => 'DESC', 'ignore_sticky_posts' => 1  ) );
						} elseif($pop_popularby == 'yearly') {
							$popularpost = new WP_Query( array( 'post_type' => 'post', 'year' => $year, 'posts_per_page' => $pop_number, 'category_name' => $pop_categ_slug, 'meta_key' => 'wise_post_views_count', 'orderby' => 'meta_value_num', 'order' => 'DESC', 'ignore_sticky_posts' => 1  ) );
						} else {
							$popularpost = new WP_Query( array( 'post_type' => 'post', 'posts_per_page' => $pop_number, 'category_name' => $pop_categ_slug, 'meta_key' => 'wise_post_views_count', 'orderby' => 'meta_value_num', 'order' => 'DESC', 'ignore_sticky_posts' => 1  ) );
						}
						
						if( $popularpost -> have_posts() ) {					
							while( $popularpost -> have_posts() ) : $popularpost -> the_post();

								echo '<li>' . '<a href="' . esc_url(esc_url(get_the_permalink())) . ' "> ';
								
								if ( has_post_thumbnail() ) {
									echo '<span class="alignleft-side">';
									the_post_thumbnail('wise-side-thumb');
									echo '</span>';
								} else { null; }
								
								echo '<div class="url-popular"><h4>' . esc_html(get_the_title()) . '</h4><span class="entry-meta-popular">';
								if( function_exists('wise_posted_on') ) : wise_posted_on(); endif;
								echo '</span></div></a></li>';

							endwhile;
							wp_reset_postdata();
						} else {
							echo '<div class="wise-error-message error-widget"><p>' . wp_kses( __('No popular posts at this time', 'wise-church'), $wise_allowed_html ) . '</p></div>'; 
						}
						
						echo '</ul></div><!-- End Popular Posts -->'; ?>
					</div><!-- End Popular Tab -->
					<div id="recent">
						<?php // Output for Recent Posts
						echo '<div class="custom-posts"><ul>';
						
						if( $rec_order == 'title' ) {
							$rec_ascdesc = 'ASC';
						} else {
							$rec_ascdesc = 'DESC';
						}
				
						if( $rec_categ != null ) {
							$rec_categ_slug = $rec_categ;
						} else { $rec_categ_slug = null; }
						
						$rec_query = new WP_Query( array( 'post_type' => 'post', 'posts_per_page' => $rec_number, 'category_name' => $rec_categ_slug, 'ignore_sticky_posts' => 1, 'post_status' => 'publish', 'orderby' => $rec_order, 'order' => $rec_ascdesc ) );

						if( $rec_query -> have_posts() ) {
							while( $rec_query -> have_posts() ) : $rec_query -> the_post();
							
								echo '<li>' . '<a href="' . esc_url( get_the_permalink() ) . ' "> ';
								
								if ( has_post_thumbnail() ) {
									echo '<span class="alignleft-side">';
									the_post_thumbnail('wise-side-thumb');
									echo '</span>';
								} else { null; }
								
								echo '<div class="url-popular"><h4>' . esc_html(get_the_title()) . '</h4><span class="entry-meta-popular">';
								if( function_exists('wise_posted_on') ) : wise_posted_on(); endif;
								echo '</span></div></a></li>';
								
							endwhile;
							wp_reset_postdata();
						} else {
							echo '<div class="wise-error-message error-widget"><p>' . wp_kses( __('No recent posts at this time', 'wise-church'), $wise_allowed_html ) . '</p></div>'; 
						}
						
						echo '</ul></div><!-- End Recent Posts -->'; ?>
					</div><!-- End Recent Tab -->
				</div><!-- End Tab Content -->
			</div><!-- End Tab Widget -->
		</div><!-- End Tab Widget Wrapper --><?php
    } // End args, instance
}