<?php
/*
* Wise Recent Posts Widget
*
*/
use Carbon_Fields\Widget;
use Carbon_Fields\Field;

class RecentPostsWidget extends Widget {
	
    // Register widget function. Must have the same name as the class
    function __construct() {
		global $wp_cats;
        $this->setup( 'wise_rec_widget', esc_attr__( '#Wise Recent Posts', 'wise-church' ), esc_attr__( 'Displays custom recent posts widget.', 'wise-church' ) , array(
			Field::make( 'text', 'wise_rec_title', esc_attr__( 'Title:', 'wise-church' ) ),
			Field::make( 'text', 'wise_rec_number', esc_attr__( 'Number of posts to show:', 'wise-church' ) )->set_default_value('4'),
			Field::make( 'select', 'wise_rec_categ', esc_attr__( 'Select Category:', 'wise-church' ) )
				->add_options($wp_cats),
			Field::make( 'select', 'wise_rec_orderby', esc_attr__( 'Order by:', 'wise-church' ) )
				->add_options(array(
					'date' => esc_attr__( 'Date', 'wise-church' ),
					'rand' => esc_attr__( 'Random', 'wise-church' ),
					'title' => esc_attr__( 'Title', 'wise-church' ),
					'comment_count' => esc_attr__( 'Comment', 'wise-church' ),
				))->set_default_value('date')
        ));
		$this->print_wrappers = false; // disable wrapper
    }

    // Called when rendering the widget in the front-end
    function front_end($args, $instance) {
		global $wise_allowed_html;
		$before_widget = !empty( $args['before_widget'] ) ? $args['before_widget'] : '';
		$before_title = !empty( $args['before_title'] ) ? $args['before_title'] : '';
		$after_title = !empty( $args['after_title'] ) ? $args['after_title'] : '';
		$after_widget = !empty( $args['after_widget'] ) ? $args['after_widget'] : '';
		
		$wise_title = !empty( $instance['wise_rec_title'] ) ? $instance['wise_rec_title'] : '';
		$number = !empty( $instance['wise_rec_number'] ) ? $instance['wise_rec_number'] : '';
		$categ = !empty( $instance['wise_rec_categ'] ) ? $instance['wise_rec_categ'] : '';
		$order = !empty( $instance['wise_rec_orderby'] ) ? $instance['wise_rec_orderby'] : '';
		
		echo wp_kses_post($before_widget); // Before widget
		
		if ( !empty($wise_title) ) { // Widget title
			echo wp_kses_post($before_title) . esc_html($wise_title) . wp_kses_post($after_title);
		} else {
			echo wp_kses_post($before_title) . esc_html__( 'Recent Posts', 'wise-church' ) . wp_kses_post($after_title);
		}
		
		if( $order == 'title' ) {
			$ascdesc = 'ASC';
		} else {
			$ascdesc = 'DESC';
		}
		
		// The Output
		echo '<div class="custom-posts"><ul>';
		
		if( $categ != null ) {
			$categ_slug = $categ;
		} else { $categ_slug = null; }
		
		$rec_query = new WP_Query( array( 'post_type' => 'post', 'posts_per_page' => $number, 'category_name' => $categ_slug, 'ignore_sticky_posts' => 1, 'post_status' => 'publish', 'orderby' => $order, 'order' => $ascdesc ) );

		if( $rec_query -> have_posts() ) {
			while( $rec_query -> have_posts() ) : $rec_query -> the_post();
			
				echo '<li>' . '<a href="' . esc_url( get_the_permalink() ) . ' "> ';
				
				if ( has_post_thumbnail() ) {
					echo '<span class="alignleft-side">';
					the_post_thumbnail('wise-side-thumb');
					echo '</span>';
				} else { null; }
				
				echo '<div class="url-popular"><h4>' . esc_html(get_the_title()) . '</h4><span class="entry-meta-popular">';
				if( function_exists('wise_posted_on') ) : wise_posted_on(); endif;
				echo '</span></div></a></li>';
				
			endwhile;
			wp_reset_postdata();
		} else {
			echo '<div class="wise-error-message error-widget"><p>' . wp_kses( __('No recent posts at this time', 'wise-church'), $wise_allowed_html ) . '</p></div>'; 
		}
		
		echo '</ul></div><!-- End Recent Posts -->';
		
		echo wp_kses_post($after_widget); // After widget
		
    } // End args, instance
}