<?php
/*
* Wise Tab Sermons Widget
*
*/
use Carbon_Fields\Widget;
use Carbon_Fields\Field;

class TabSermonsWidget extends Widget {
	
    // Register widget function. Must have the same name as the class
    function __construct() {
        $this->setup( 'wise_tab_sermon_widget', esc_attr__( '#Wise CTC Tab Sermons', 'wise-church' ), esc_attr__( 'Displays tab popular and recent sermons widget.', 'wise-church' ) , array(
			// Popular Sermons
			Field::make( 'separator', 'wise_pop_style_options_tab_ser', esc_attr__( 'Popular Sermons Tab', 'wise-church' ) ),
			Field::make( 'text', 'wise_pop_title_sermon', esc_attr__( 'Title:', 'wise-church' ) ),
			Field::make( 'text', 'wise_pop_number_sermon', esc_attr__( 'Number of sermons to show:', 'wise-church' ) )
				->set_default_value('4'),
			Field::make( 'radio', 'wise_pop_popularby_sermon', esc_attr__( 'Popular sermons created on:', 'wise-church' ) )
				->add_options(array(
					'weekly' => esc_attr__( 'This Week', 'wise-church' ),
					'monthly' => esc_attr__( 'This Month', 'wise-church' ),
					'yearly' => esc_attr__( 'This Year', 'wise-church' ),
					'alltime' => esc_attr__( 'All Time', 'wise-church' ),
				))->set_default_value('alltime'),
			// Recent Sermons
			Field::make('separator', 'wise_rec_style_options_sermon', esc_attr__( 'Recent Sermons Tab', 'wise-church' ) ),
			Field::make('text', 'wise_rec_title_sermon', esc_attr__( 'Title:', 'wise-church' ) ),
			Field::make('text', 'wise_rec_number_sermon', esc_attr__( 'Number of sermons to show:', 'wise-church' ) )
				->set_default_value('4'),
			Field::make('select', 'wise_rec_orderby_sermon', esc_attr__( 'Order by:', 'wise-church' ) )
				->add_options(array(
					'date' => esc_attr__( 'Date', 'wise-church' ),
					'rand' => esc_attr__( 'Random', 'wise-church' ),
					'title' => esc_attr__( 'Title', 'wise-church' ),
					'comment_count' => esc_attr__( 'Comment', 'wise-church' ),
				))->set_default_value('date')
        ));
		$this->print_wrappers = false; // disable wrapper
    }

    // Called when rendering the widget in the front-end
    function front_end($args, $instance) {
		global $wise_allowed_html;

		// Popular Sermons
		$pop_title = !empty( $instance['wise_pop_title_sermon'] ) ? ( $instance['wise_pop_title_sermon'] ) : '';
		$pop_number = !empty( $instance['wise_pop_number_sermon'] ) ? ( $instance['wise_pop_number_sermon'] ) : '';
		$pop_popularby = !empty( $instance['wise_pop_popularby_sermon'] ) ? ( $instance['wise_pop_popularby_sermon'] ) : '';
		
		// Recent Sermons
		$rec_title = !empty( $instance['wise_rec_title_sermon'] ) ? ( $instance['wise_rec_title_sermon'] ) : '';
		$rec_number = !empty( $instance['wise_rec_number_sermon'] ) ? ( $instance['wise_rec_number_sermon'] ) : '';
		$rec_order = !empty( $instance['wise_rec_orderby_sermon'] ) ? ( $instance['wise_rec_orderby_sermon'] ) : '';
		
		if ( !empty($pop_title) ) { // Popular Tab Title
			$pop_title_output = $pop_title;
		} else {
			$pop_title_output = esc_attr__( 'Most Popular', 'wise-church' );
		}
		
		if ( !empty($rec_title) ) { // Recent Tab Title
			$rec_title_output = $rec_title;
		} else {
			$rec_title_output = esc_attr__( 'Most Recent', 'wise-church' );
		}
		
		// The Output ?>
		<div class="wise-tabs">
			<div class="widget tab-sidebar">
				<ul class="wise-nav">
					<li><a href="#popularsermon"><?php echo esc_html($pop_title_output); ?></a></li>
					<li><a href="#recentsermon"><?php echo esc_html($rec_title_output); ?></a></li>
				</ul>

				<div class="tab-content">
					<div id="popularsermon">
						<?php // Output for Popular Sermons
						echo '<div class="custom-posts"><ul>';
						
						$week = date_i18n( 'W' );
						$month = date_i18n( 'm' );
						$year = date_i18n( 'Y' );
						
						if($pop_popularby == 'weekly') {
							$popularpost_sermon = new WP_Query( array( 'post_type' => 'ctc_sermon', 'year' => $year, 'w' => $week, 'posts_per_page' => $pop_number, 'meta_key' => 'wise_post_views_count', 'orderby' => 'meta_value_num', 'order' => 'DESC', 'ignore_sticky_posts' => 1  ) );
						} elseif($pop_popularby == 'monthly') {
							$popularpost_sermon = new WP_Query( array( 'post_type' => 'ctc_sermon', 'year' => $year, 'monthnum' => $month, 'posts_per_page' => $pop_number, 'meta_key' => 'wise_post_views_count', 'orderby' => 'meta_value_num', 'order' => 'DESC', 'ignore_sticky_posts' => 1  ) );
						} elseif($pop_popularby == 'yearly') {
							$popularpost_sermon = new WP_Query( array( 'post_type' => 'ctc_sermon', 'year' => $year, 'posts_per_page' => $pop_number, 'meta_key' => 'wise_post_views_count', 'orderby' => 'meta_value_num', 'order' => 'DESC', 'ignore_sticky_posts' => 1  ) );
						} else {
							$popularpost_sermon = new WP_Query( array( 'post_type' => 'ctc_sermon', 'posts_per_page' => $pop_number, 'meta_key' => 'wise_post_views_count', 'orderby' => 'meta_value_num', 'order' => 'DESC', 'ignore_sticky_posts' => 1  ) );
						}
						
						if( $popularpost_sermon -> have_posts() ) {					
							while( $popularpost_sermon -> have_posts() ) : $popularpost_sermon -> the_post();

								echo '<li>' . '<a href="' . esc_url(esc_url(get_the_permalink())) . ' "> ';
								
								if ( has_post_thumbnail() ) {
									echo '<span class="alignleft-side">';
									the_post_thumbnail('wise-side-thumb');
									echo '</span>';
								} else { null; }
								
								echo '<div class="url-popular"><h4>' . esc_html(get_the_title()) . '</h4><span class="entry-meta-popular">';
								if( function_exists('wise_posted_on') ) : wise_posted_on(); endif;
								echo '</span></div></a></li>';

							endwhile;
							wp_reset_postdata();
						} else {
							echo '<div class="wise-error-message error-widget"><p>' . wp_kses( __('No popular posts at this time', 'wise-church'), $wise_allowed_html ) . '</p></div>'; 
						}
						
						echo '</ul></div><!-- End Popular Posts -->'; ?>
					</div><!-- End Popular Tab -->
					<div id="recentsermon">
						<?php // Output for Recent Sermons
						echo '<div class="custom-posts"><ul>';
						
						if( $rec_order == 'title' ) {
							$rec_ascdesc = 'ASC';
						} else {
							$rec_ascdesc = 'DESC';
						}
						
						$rec_sermon_query = new WP_Query( array( 'post_type' => 'ctc_sermon', 'posts_per_page' => $rec_number, 'ignore_sticky_posts' => 1, 'post_status' => 'publish', 'orderby' => $rec_order, 'order' => $rec_ascdesc ) );

						if( $rec_sermon_query -> have_posts() ) {
							while( $rec_sermon_query -> have_posts() ) : $rec_sermon_query -> the_post();
							
								echo '<li>' . '<a href="' . esc_url( get_the_permalink() ) . ' "> ';
								
								if ( has_post_thumbnail() ) {
									echo '<span class="alignleft-side">';
									the_post_thumbnail('wise-side-thumb');
									echo '</span>';
								} else { null; }
								
								echo '<div class="url-popular"><h4>' . esc_html(get_the_title()) . '</h4><span class="entry-meta-popular">';
								if( function_exists('wise_posted_on') ) : wise_posted_on(); endif;
								echo '</span></div></a></li>';
								
							endwhile;
							wp_reset_postdata();
						} else {
							echo '<div class="wise-error-message error-widget"><p>' . wp_kses( __('No recent posts at this time', 'wise-church'), $wise_allowed_html ) . '</p></div>'; 
						}
						
						echo '</ul></div><!-- End Recent Posts -->'; ?>
					</div><!-- End Recent Tab -->
				</div><!-- End Tab Content -->
			</div><!-- End Tab Widget -->
		</div><!-- End Tab Widget Wrapper --><?php
    } // End args, instance
}