<?php
/*
Plugin Name: Wise Blog Contents
Plugin URI: https://www.probewise.com/themes/wise-blog/
Description: A plugin for Wise Blog WordPress theme to activate important features.
Author: Probewise
Version: 20250807
Author URI: https://www.probewise.com/
Text Domain: wise-blog
*/

if ( ! defined( 'ABSPATH' ) ) exit;

if ( !defined( 'WISEBC_PLUGIN_DIR' ) ) {
	define( 'WISEBC_PLUGIN_DIR', __DIR__ );
}

/*--------------------------------------------------------------
1. Additional Functions
--------------------------------------------------------------*/
require WISEBC_PLUGIN_DIR . '/inc/additional-functions.php';

/*--------------------------------------------------------------
2. Customizer Reset
--------------------------------------------------------------*/
require WISEBC_PLUGIN_DIR . '/inc/customizer-reset.php';

/*--------------------------------------------------------------
3. Load Text Domain
--------------------------------------------------------------*/
function wise_blog_contents_text_domain() {
	$wise_locale = get_locale();
	load_textdomain( 'wise-blog', WISEBC_PLUGIN_DIR .'/lang/' . $wise_locale . '.mo' );
}
add_action( 'plugins_loaded', 'wise_blog_contents_text_domain' );

/*--------------------------------------------------------------
4. Global Variables
--------------------------------------------------------------*/
// WP KSES Allowed HTML
$wise_allowed_html = array(
	'a' => array(
		'href' => array(),
		'title' => array(),
		'alt' => array(),
		'target' => array(),
		'rel' => array()
	),
	'br' => array(),
	'em' => array(),
	'strong' => array(),
	'i' => array(),
	'span' => array()
);

/* List Categories */
global $wp_cats;
$categories = get_categories('hide_empty=0&orderby=name');
$wp_cats = array();
foreach ($categories as $category_list ) {
	$wp_cats[$category_list->slug] = $category_list->cat_name;
}
array_unshift($wp_cats, '');