<?php
/*
* Wise Ticker Widget
*
*/
use Carbon_Fields\Widget;
use Carbon_Fields\Field;

class WiseTickerWidget extends Widget {

	// Register widget function. Must have the same name as the class
	function __construct() {
		global $wp_cats;
		$this->setup( 'wise_ticker_widget', esc_attr__( '#Wise Ticker', 'wise-blog' ), esc_attr__( 'Displays wise ticker widget', 'wise-blog' ) , array(
			Field::make( 'separator', 'wise_tickblock_title', esc_attr__( 'Wise Ticker Block', 'wise-blog' ) ),
			Field::make( 'text', 'wise_tname', esc_attr__( 'Wise Ticker Label', 'wise-blog' ) ),
			Field::make( 'select', 'wise_ttype', esc_attr__( 'Type of Posts to Show', 'wise-blog' ) )
				->add_options(array(
					'trending' => esc_attr__( 'Trending Posts by Views', 'wise-blog' ),
					'trendingc' => esc_attr__( 'Trending Posts by Comments', 'wise-blog' ),
					'latest' => esc_attr__( 'Latest Posts', 'wise-blog' ),
				))->set_default_value('trending'),
			Field::make( 'select', 'wise_ttype_categ', esc_attr__( 'Post Categories', 'wise-blog' ) )
				->add_options($wp_cats),
			Field::make( 'text', 'wise_tnumber', esc_attr__( 'No. of Posts', 'wise-blog' ) )
				->set_default_value('7'),
			Field::make( 'text', 'wise_tick_time', esc_attr__( 'Ticker Speed in Seconds', 'wise-blog' ) ),
			Field::make( 'checkbox', 'tdis_home', esc_attr__( 'Disable on Homepage', 'wise-blog' ) )
				->set_option_value('yes'),
			Field::make( 'checkbox', 'tdis_arch', esc_attr__( 'Disable on Archives', 'wise-blog' ) )
				->set_option_value('yes'),
			Field::make( 'checkbox', 'tdis_post', esc_attr__( 'Disable on Posts', 'wise-blog' ) )
				->set_option_value('yes'),
			Field::make( 'checkbox', 'tdis_page', esc_attr__( 'Disable on Pages', 'wise-blog' ) )
				->set_option_value('yes'),
			Field::make( 'checkbox', 'tdis_tagcond', esc_attr__( 'Disable if has tag: wise-noticker', 'wise-blog' ) )
				->set_option_value('yes')
		));
		$this->print_wrappers = false; // disable wrapper
	}

	// Called when rendering the widget in the front-end
	function front_end($args, $instance) {
		global $wise_tnumber, $wise_ttype, $wise_ttype_categ, $wise_tick_time;
		$wise_tname = !empty( $instance['wise_tname'] ) ? ( $instance['wise_tname'] ) : '';
		$wise_ttype = !empty( $instance['wise_ttype'] ) ? ( $instance['wise_ttype'] ) : '';
		$wise_ttype_categ = !empty( $instance['wise_ttype_categ'] ) ? ( $instance['wise_ttype_categ'] ) : '';
		$wise_tnumber = !empty( $instance['wise_tnumber'] ) ? ( $instance['wise_tnumber'] ) : '';
		$wise_tick_time = !empty( $instance['wise_tick_time'] ) ? ( $instance['wise_tick_time'] ) : '';
		$wise_tds_home = !empty( $instance['tdis_home'] ) ? ( $instance['tdis_home'] ) : '';
		$wise_tds_archive = !empty( $instance['tdis_arch'] ) ? ( $instance['tdis_arch'] ) : '';
		$wise_tds_post = !empty( $instance['tdis_post'] ) ? ( $instance['tdis_post'] ) : '';
		$wise_tds_page = !empty( $instance['tdis_page'] ) ? ( $instance['tdis_page'] ) : '';
		$wise_tagcond_ticker = !empty( $instance['tdis_tagcond'] ) ? $instance['tdis_tagcond'] : '';
		
		$disable_ads = carbon_get_post_meta( get_the_ID(), 'wise_disads_post' );

		ob_start();
		dynamic_sidebar('sidebar-6');
		$wise_sidebar_top = ob_get_clean();

		if( function_exists('is_woocommerce') && function_exists('is_bbpress') ) { // If WooCommerce and bbPress exists
			if( !is_404() && !is_search() && !is_attachment() && !is_woocommerce() && !is_bbpress() && ($wise_tds_home == true ? ( !is_home() && !is_front_page() ) : true ) && ($wise_tds_archive == true ? !is_archive() : true ) && ($wise_tds_page == true ? !is_page() || is_front_page() : true ) && ($wise_tds_post == true ? !is_single() : true ) && ( $wise_tagcond_ticker == true ? !has_tag('wise-noticker') : true ) ) {
				?><div class="wise-ticker wise-ticker-widget clear<?php if( !is_active_sidebar('sidebar-6') || empty($wise_sidebar_top) ) : echo ' forty-padding-top'; endif; ?>">
					<div class="wise-tcaption"><h4><?php if( !empty($wise_tname) ) { echo esc_html($wise_tname); } else { echo esc_html__( 'Trending Now', 'wise-blog' ); } ?></h4></div>
					<div class="wise-tcont"><?php include WISEBC_PLUGIN_DIR . '/templates/content-wise-ticker.php'; ?></div>
				</div><?php
			} else { null; }
		} elseif( function_exists('is_woocommerce') ) { // If WooCommerce exists
			if( !is_404() && !is_search() && !is_attachment() && !is_woocommerce() && ($wise_tds_home == true ? ( !is_home() && !is_front_page() ) : true ) && ($wise_tds_archive == true ? !is_archive() : true ) && ($wise_tds_page == true ? !is_page() || is_front_page() : true ) && ($wise_tds_post == true ? !is_single() : true ) && ( $wise_tagcond_ticker == true ? !has_tag('wise-noticker') : true ) ) {
				?><div class="wise-ticker wise-ticker-widget clear<?php if( !is_active_sidebar('sidebar-6') || empty($wise_sidebar_top) ) : echo ' forty-padding-top'; endif; ?>">
					<div class="wise-tcaption"><h4><?php if( !empty($wise_tname) ) { echo esc_html($wise_tname); } else { echo esc_html__( 'Trending Now', 'wise-blog' ); } ?></h4></div>
					<div class="wise-tcont"><?php include WISEBC_PLUGIN_DIR . '/templates/content-wise-ticker.php'; ?></div>
				</div><?php
			} else { null; }
		} elseif( function_exists('is_bbpress') ) { // If bbPress exists
			if( !is_404() && !is_search() && !is_attachment() && !is_bbpress() && ($wise_tds_home == true ? ( !is_home() && !is_front_page() ) : true ) && ($wise_tds_archive == true ? !is_archive() : true ) && ($wise_tds_page == true ? !is_page() || is_front_page() : true ) && ($wise_tds_post == true ? !is_single() : true ) && ( $wise_tagcond_ticker == true ? !has_tag('wise-noticker') : true ) ) {
				?><div class="wise-ticker wise-ticker-widget clear<?php if( !is_active_sidebar('sidebar-6') || empty($wise_sidebar_top) ) : echo ' forty-padding-top'; endif; ?>">
					<div class="wise-tcaption"><h4><?php if( !empty($wise_tname) ) { echo esc_html($wise_tname); } else { echo esc_html__( 'Trending Now', 'wise-blog' ); } ?></h4></div>
					<div class="wise-tcont"><?php include WISEBC_PLUGIN_DIR . '/templates/content-wise-ticker.php'; ?></div>
				</div><?php
			} else { null; }
		} else {
			if( !is_404() && !is_search() && !is_attachment() && ($wise_tds_home == true ? ( !is_home() && !is_front_page() ) : true ) && ($wise_tds_archive == true ? !is_archive() : true ) && ($wise_tds_page == true ? !is_page() || is_front_page() : true ) && ($wise_tds_post == true ? !is_single() : true ) && ( $wise_tagcond_ticker == true ? !has_tag('wise-noticker') : true ) ) {
				?><div class="wise-ticker wise-ticker-widget clear<?php if( !is_active_sidebar('sidebar-6') || empty($wise_sidebar_top) ) : echo ' forty-padding-top'; endif; ?>">
					<div class="wise-tcaption"><h4><?php if( !empty($wise_tname) ) { echo esc_html($wise_tname); } else { echo esc_html__( 'Trending Now', 'wise-blog' ); } ?></h4></div>
					<div class="wise-tcont"><?php include WISEBC_PLUGIN_DIR . '/templates/content-wise-ticker.php'; ?></div>
				</div><?php
			} else { null; }
		}		

	} // End args, instance

} // End class