<?php
/*
* Wise Footer Sitelinks Widget
*
*/
use Carbon_Fields\Widget;
use Carbon_Fields\Field;

class FooterSitelinksWidget extends Widget {

	// Register widget function. Must have the same name as the class
	function __construct() {
		$this->setup( 'wise_sitelinks_widget', esc_attr__( '#Wise Footer Sitelinks', 'wise-blog' ), esc_attr__( 'Displays sitelinks widget for footer.', 'wise-blog' ) , array(
			Field::make( 'text', 'wise_sitelinks_title', esc_attr__( 'Title:', 'wise-blog' ) ),
			Field::make( 'checkbox', 'wise_sitelinks_title_dis', esc_attr__( 'Disable Title', 'wise-blog' ) )
				->set_default_value('no')
		));
		$this->print_wrappers = false; // disable wrapper
	}

	// Called when rendering the widget in the front-end
	function front_end($args, $instance) {
		$before_widget = !empty( $args['before_widget'] ) ? $args['before_widget'] : '';
		$before_title = !empty( $args['before_title'] ) ? $args['before_title'] : '';
		$after_title = !empty( $args['after_title'] ) ? $args['after_title'] : '';
		$after_widget = !empty( $args['after_widget'] ) ? $args['after_widget'] : '';
		
		$wise_title = !empty( $instance['wise_sitelinks_title'] ) ? $instance['wise_sitelinks_title'] : '';
		$wise_title_dis = !empty( $instance['wise_sitelinks_title_dis'] ) ? $instance['wise_sitelinks_title_dis'] : '';
		
		echo wp_kses_post($before_widget); // Before widget
		
		if( $wise_title_dis != 'yes' ) :
			if ( !empty($wise_title) ) { // Widget title
				echo wp_kses_post($before_title) . esc_html($wise_title) . wp_kses_post($after_title);
			} else {
				echo wp_kses_post($before_title) . esc_html__( 'Site Links', 'wise-blog' ) . wp_kses_post($after_title);
			}
		endif;
		
		// The Output
		echo '<div class="site-links">';

		$first_args = array( // First Column
			'theme_location' => 'sitelinks_first',
			'menu_class' => 'td',
			'fallback_cb' => 'wise_menu_message'
		);
		wp_nav_menu($first_args);
		
		$second_args = array( // Second Column
			'theme_location' => 'sitelinks_second',
			'menu_class' => 'td',
			'fallback_cb' => 'wise_menu_message'
		);
		wp_nav_menu($second_args);
			
		echo '</div>'; // End Sitelinks
		
		echo wp_kses_post($after_widget); // After widget
	
	} // End args, instance
}